<?php
header('Content-Type: application/json');
include("config.php");
$___notjson = 1;

try {
    // Подключаем базу данных SQLite
    $db = new PDO('sqlite:emotions.sqlite');

    // Создаем таблицы для модулей, если они отсутствуют
    foreach ($modules as $module) {
        if (!tableExists($db, $module)) {
            $db->exec("CREATE TABLE `{$module}` (
                `id` INTEGER PRIMARY KEY,
                `emotions` TEXT,
                `idlist` TEXT,
                `iplist` TEXT
            )");
        }
    }

    // Режим act=3: объединённый запрос для каталога материалов (только статистика, без возможности голосовать)
    if ($_GET['act'] == 3) {
        // Получаем параметр list (ожидается JSON-массив)
        $listRaw = isset($_GET['list']) ? $_GET['list'] : '';
        // Убираем лишние обратные слэши, если они есть
        $listRaw = stripcslashes($listRaw);
        $list = json_decode($listRaw, true);
        if (!is_array($list)) {
            die(json_encode(array("error" => "Invalid list", "received" => $listRaw)));
        }
        $result = array();
        foreach ($list as $item) {
            $module = isset($item['module']) ? $item['module'] : "";
            $id = isset($item['id']) ? intval($item['id']) : 0;
            // Если module не задан, id невалидный или таблица отсутствует – возвращаем ошибку для данного элемента
            if ($module == "" || $id <= 0 || !tableExists($db, $module)) {
                $result["{$module}-{$id}"] = array("error" => "Invalid module or id");
                continue;
            }
            $query = $db->query("SELECT * FROM `{$module}` WHERE `id` = '{$id}'")->fetchAll();
            if (count($query) == 0) {
                $result["{$module}-{$id}"] = array(
                    "id" => $id,
                    "emotions" => array(),
                    "total" => 0,
                    "canvote" => 1,
                    "active" => null
                );
            } else {
                $total = 0;
                $canvote = 1;
                $active = null;
                if (($uid = ucoz_getinfo("SITEUSERID")) != 0) {
                    $idlist = explode(",", $query[0]['idlist']);
                    foreach ($idlist as $entry) {
                        if (strpos($entry, ':') !== false) {
                            list($storedUid, $storedEmotion) = explode(":", $entry);
                            if ($storedUid == $uid) {
                                $canvote = 0;
                                $active = intval($storedEmotion);
                                break;
                            }
                        } else {
                            if ($entry == $uid) {
                                $canvote = 0;
                                $active = 1;
                                break;
                            }
                        }
                    }
                } else {
                    $iplist = explode(",", $query[0]['iplist']);
                    foreach ($iplist as $entry) {
                        if (strpos($entry, ':') !== false) {
                            list($storedIp, $storedEmotion) = explode(":", $entry);
                            if ($storedIp == $_SERVER['REMOTE_ADDR']) {
                                $canvote = 0;
                                $active = intval($storedEmotion);
                                break;
                            }
                        } else {
                            if ($entry == $_SERVER['REMOTE_ADDR']) {
                                $canvote = 0;
                                $active = 1;
                                break;
                            }
                        }
                    }
                }
                $emotions = json_decode($query[0]['emotions'], true);
                if (!is_array($emotions)) {
                    $emotions = array();
                }
                foreach ($emotions as $e) {
                    $total += $e;
                }
                $result["{$module}-{$id}"] = array(
                    "id" => $id,
                    "emotions" => $emotions,
                    "total" => $total,
                    "canvote" => $canvote,
                    "active" => $active
                );
            }
        }
        echo json_encode($result);
        exit();
    }
    // Режим act=1: получение данных для одного материала (используется на странице материала)
    else if ($_GET['act'] == 1) {
        if (!tableExists($db, $_GET['module']))
            die(json_encode(array("error" => "Invalid module")));
        $id = intval($_GET['id']);
        if ($id <= 0)
            die(json_encode(array("error" => "Invalid id")));
        $query = $db->query("SELECT * FROM `{$_GET['module']}` WHERE `id` = '{$id}'")->fetchAll();
        if (count($query) == 0) {
            echo json_encode(array(
                "id" => $id,
                "emotions" => array(),
                "total" => 0,
                "canvote" => 1,
                "active" => null
            ));
            exit();
        } else {
            $total = 0;
            $canvote = 1;
            $active = null;
            if (($uid = ucoz_getinfo("SITEUSERID")) != 0) {
                $idlist = explode(",", $query[0]['idlist']);
                foreach ($idlist as $entry) {
                    if (strpos($entry, ':') !== false) {
                        list($storedUid, $storedEmotion) = explode(":", $entry);
                        if ($storedUid == $uid) {
                            $canvote = 0;
                            $active = intval($storedEmotion);
                            break;
                        }
                    } else {
                        if ($entry == $uid) {
                            $canvote = 0;
                            $active = 1;
                            break;
                        }
                    }
                }
            } else {
                $iplist = explode(",", $query[0]['iplist']);
                foreach ($iplist as $entry) {
                    if (strpos($entry, ':') !== false) {
                        list($storedIp, $storedEmotion) = explode(":", $entry);
                        if ($storedIp == $_SERVER['REMOTE_ADDR']) {
                            $canvote = 0;
                            $active = intval($storedEmotion);
                            break;
                        }
                    } else {
                        if ($entry == $_SERVER['REMOTE_ADDR']) {
                            $canvote = 0;
                            $active = 1;
                            break;
                        }
                    }
                }
            }
            $emotions = json_decode($query[0]['emotions'], true);
            if (!is_array($emotions)) {
                $emotions = array();
            }
            foreach ($emotions as $e) {
                $total += $e;
            }
            echo json_encode(array(
                "id" => $id,
                "emotions" => $emotions,
                "total" => $total,
                "canvote" => $canvote,
                "active" => $active
            ));
            exit();
        }
    }
    // Режим act=2: обработка голосования (изменение данных)
    else if ($_GET['act'] == 2) {
        if (!tableExists($db, $_GET['module']))
            die(json_encode(array("error" => "Invalid module")));
        $emotion = intval($_GET['emotion']);
        if ($emotion < 1 || $emotion > 6)
            die(json_encode(array("error" => "Invalid emotion")));
        $id = intval($_GET['id']);
        if ($id <= 0)
            die(json_encode(array("error" => "Invalid id")));
        $uid = ucoz_getinfo("SITEUSERID");
        if ($uid == 0) {
            $uid = null;
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        $query = $db->query("SELECT * FROM `{$_GET['module']}` WHERE `id` = '{$id}'")->fetchAll();
        if (count($query) == 0) {
            $emotions = array();
            for ($i = 1; $i <= 6; $i++) {
                $emotions[$i] = 0;
            }
            $emotions[$emotion] = 1;
            if ($uid !== null) {
                $idlist = "$uid:$emotion";
                $iplist = "";
            } else {
                $idlist = "";
                $iplist = "$ip:$emotion";
            }
            $db->exec("INSERT INTO `{$_GET['module']}` (`id`, `emotions`, `idlist`, `iplist`) VALUES ('{$id}', '" . json_encode($emotions) . "', '{$idlist}', '{$iplist}')");
            echo json_encode(array("id" => $id, "emotions" => $emotions, "total" => 1, "active" => $emotion));
            exit();
        } else {
            $emotions = json_decode($query[0]['emotions'], true);
            if (!is_array($emotions)) {
                $emotions = array();
            }
            if (!isset($emotions[$emotion])) {
                $emotions[$emotion] = 0;
            }
            if ($uid != null) {
                $idlist = ($query[0]['idlist'] != "") ? explode(",", $query[0]['idlist']) : array();
                $found = false;
                $prevEmotion = null;
                foreach ($idlist as $key => $entry) {
                    if (strpos($entry, ':') !== false) {
                        list($storedUid, $storedEmotion) = explode(":", $entry);
                        if ($storedUid == $uid) {
                            $found = true;
                            $prevEmotion = intval($storedEmotion);
                            break;
                        }
                    } else {
                        if ($entry == $uid) {
                            $found = true;
                            $prevEmotion = 1;
                            break;
                        }
                    }
                }
                if ($found) {
                    if ($prevEmotion == $emotion) {
                        if ($emotions[$prevEmotion] > 0) {
                            $emotions[$prevEmotion]--;
                        }
                        $newIdlist = array();
                        foreach ($idlist as $entry) {
                            if (strpos($entry, ':') !== false) {
                                list($storedUid, $storedEmotion) = explode(":", $entry);
                                if ($storedUid != $uid) {
                                    $newIdlist[] = $entry;
                                }
                            } else {
                                if ($entry != $uid) {
                                    $newIdlist[] = $entry;
                                }
                            }
                        }
                        $idlist = $newIdlist;
                        $active = null;
                    } else {
                        if ($emotions[$prevEmotion] > 0) {
                            $emotions[$prevEmotion]--;
                        }
                        $emotions[$emotion]++;
                        foreach ($idlist as $key => $entry) {
                            if (strpos($entry, ':') !== false) {
                                list($storedUid, $storedEmotion) = explode(":", $entry);
                                if ($storedUid == $uid) {
                                    $idlist[$key] = "$uid:$emotion";
                                    break;
                                }
                            } else {
                                if ($entry == $uid) {
                                    $idlist[$key] = "$uid:$emotion";
                                    break;
                                }
                            }
                        }
                        $active = $emotion;
                    }
                } else {
                    $idlist[] = "$uid:$emotion";
                    $emotions[$emotion]++;
                    $active = $emotion;
                }
                $db->exec("UPDATE `{$_GET['module']}` SET `emotions` = '" . json_encode($emotions) . "', `idlist` = '" . implode(",", $idlist) . "' WHERE `id` = '{$id}'");
            } else {
                $iplist = ($query[0]['iplist'] != "") ? explode(",", $query[0]['iplist']) : array();
                $found = false;
                $prevEmotion = null;
                foreach ($iplist as $key => $entry) {
                    if (strpos($entry, ':') !== false) {
                        list($storedIp, $storedEmotion) = explode(":", $entry);
                        if ($storedIp == $_SERVER['REMOTE_ADDR']) {
                            $found = true;
                            $prevEmotion = intval($storedEmotion);
                            break;
                        }
                    } else {
                        if ($entry == $_SERVER['REMOTE_ADDR']) {
                            $found = true;
                            $prevEmotion = 1;
                            break;
                        }
                    }
                }
                if ($found) {
                    if ($prevEmotion == $emotion) {
                        if ($emotions[$prevEmotion] > 0) {
                            $emotions[$prevEmotion]--;
                        }
                        $newIplist = array();
                        foreach ($iplist as $entry) {
                            if (strpos($entry, ':') !== false) {
                                list($storedIp, $storedEmotion) = explode(":", $entry);
                                if ($storedIp != $_SERVER['REMOTE_ADDR']) {
                                    $newIplist[] = $entry;
                                }
                            } else {
                                if ($entry != $_SERVER['REMOTE_ADDR']) {
                                    $newIplist[] = $entry;
                                }
                            }
                        }
                        $iplist = $newIplist;
                        $active = null;
                    } else {
                        if ($emotions[$prevEmotion] > 0) {
                            $emotions[$prevEmotion]--;
                        }
                        $emotions[$emotion]++;
                        foreach ($iplist as $key => $entry) {
                            if (strpos($entry, ':') !== false) {
                                list($storedIp, $storedEmotion) = explode(":", $entry);
                                if ($storedIp == $_SERVER['REMOTE_ADDR']) {
                                    $iplist[$key] = "{$_SERVER['REMOTE_ADDR']}:$emotion";
                                    break;
                                }
                            } else {
                                if ($entry == $_SERVER['REMOTE_ADDR']) {
                                    $iplist[$key] = "{$_SERVER['REMOTE_ADDR']}:$emotion";
                                    break;
                                }
                            }
                        }
                        $active = $emotion;
                    }
                } else {
                    $iplist[] = "{$_SERVER['REMOTE_ADDR']}:$emotion";
                    $emotions[$emotion]++;
                    $active = $emotion;
                }
                $db->exec("UPDATE `{$_GET['module']}` SET `emotions` = '" . json_encode($emotions) . "', `iplist` = '" . implode(",", $iplist) . "' WHERE `id` = '{$id}'");
            }
            $total = array_sum($emotions);
            echo json_encode(array(
                "id" => $id,
                "emotions" => $emotions,
                "total" => $total,
                "active" => $active
            ));
            exit();
        }
    }
    else {
        echo json_encode(array("error" => "Invalid action"));
        exit();
    }
}
catch (PDOException $e) {
    echo json_encode(array("error" => $e->getMessage()));
    exit();
}

function tableExists($pdo, $table) {
    try {
        $result = $pdo->query("SELECT 1 FROM $table LIMIT 1");
    }
    catch (Exception $e) {
        return FALSE;
    }
    return ($result !== FALSE);
}
?>
